
import os, json, yaml

def load_cfg(cfg_path):
    with open(cfg_path, "r", encoding="utf-8") as f:
        return yaml.safe_load(f)

def ensure_out(*path):
    p = os.path.join(*path)
    os.makedirs(p, exist_ok=True)
    return p

def write_md(path, text):
    with open(path, "w", encoding="utf-8") as f:
        f.write(text)
